﻿var licenses = {
    context: $(".v-licenses"),
    datatable: null,
    refreshDataTable: function () {
        licenses.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-licensesTable", licenses.context).a4datatable({
            title: resources.InstalledLicenses,
            ajaxAction: a4.getAction("GetLicenses", "Licenses", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id },
                { "Name": "IssueDate", "Title": resources.IssueDate },
                { "Name": "InstallationDate", "Title": resources.InstallationDate },
                {
                    "Name": "Expiration", "Title": resources.ExpirationDate, "Data": "ExpirationDate", "DefaultValue": resources.NeverExpires,
                    "render": function (data) {
                        if (data && new Date(data) - new Date() < 30 * 24 * 60 * 60 * 1000 /* 30 days in milliseconds */) {
                            return `<span style="color: #F0345C; font-weight: 600">${data}</span>`;
                        }
                        return data;
                    }
                }
            ],
            contextMenuItems: [
                { "Action": "details", "Label": resources.Details }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                if (action == "details") {
                    modalDialog.showWindow(a4.getAction("Details", "Licenses", "Settings", { id: row.Id }), 500, 700);
                }
            }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-requestLicense", function () {
            modalDialog.showWindow(a4.getAction("LicenseRequest", "Licenses", "Settings"), 250, 400);
        });

        $(document).on("click", ".h-installLicense", function () {
            modalDialog.showWindow(a4.getAction("ImportLicense", "Licenses", "Settings"), 380, 550);
        });
    }
}

$(document).ready(function () {
    if (licenses.context.length > 0) {
        licenses.initializeDataTable();
        licenses.bindEvents();
    }
});


